@include('layout.header')

@include('layout.sidebar')
<!-------- Customizable Css for Map  ----------------------------->
<style type="text/css">
    html {
        height: 100%;
    }
    body {
        height: 100%;
        margin: 0;
        padding: 0;
    }
    #map {
        margin: 0;
        padding: 0;
        height: 550px;
        max-width: none;
    }
    #map img {
        max-width: none !important;
    }
    .gm-style-iw {
        top: 15px !important;
        left: 0px !important;
        background-color: #fff;
    }
    #iw-container {
        margin-bottom: 10px;
    }
    #iw-container .iw-title {
        font-family: 'Open Sans Condensed', sans-serif;
        font-size: 22px;
        font-weight: 400;
        padding: 10px;
        background-color: #48b5e9;
        color: white;
        margin: 0;
        border-radius: 2px 2px 0 0;
    }
    #iw-container .iw-content {
        font-size: 13px;
        line-height: 18px;
        font-weight: 400;
        margin-right: 1px;
        padding: 15px 5px 20px 15px;
        max-height: 140px;
        overflow-y: auto;
        overflow-x: hidden;
    }
    .iw-content img {
        float: right;
        margin: 0 5px 5px 10px;	
    }
    .iw-subTitle {
        font-size: 16px;
        font-weight: 700;
        padding: 5px 0;
    }
    .iw-bottom-gradient {
        position: absolute;
        width: 326px;
        height: 25px;
        bottom: 10px;
        right: 18px;
        background: linear-gradient(to bottom, rgba(255,255,255,0) 0%, rgba(255,255,255,1) 100%);
        background: -webkit-linear-gradient(top, rgba(255,255,255,0) 0%, rgba(255,255,255,1) 100%);
        background: -moz-linear-gradient(top, rgba(255,255,255,0) 0%, rgba(255,255,255,1) 100%);
        background: -ms-linear-gradient(top, rgba(255,255,255,0) 0%, rgba(255,255,255,1) 100%);
    }
</style>

<script src="https://www.gstatic.com/firebasejs/4.3.0/firebase.js"></script>
<script type="text/javascript" src="//ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>

<div class="vd_content-wrapper">
    <div class="vd_container">
        <div class="vd_content clearfix">
            <div class="vd_content-section clearfix">
                <div id="map"></div>
                <div id="navigation"><a href="http://econotrack.com.br/econoteste/users">Voltar</a></div>
            </div>
        </div>
    </div>
</div>
<script>
    function initMap() {

        var bounds = new google.maps.LatLngBounds();
        var pt = new google.maps.LatLng(<?= $data->last_lat ?>, <?= $data->last_long ?>);
        var data = <?= json_encode($data) ?>;
        bounds.extend(pt);
        var map = new google.maps.Map(document.getElementById('map'), {
            zoom: 18,
            center: pt,
            mapTypeId: 'roadmap'
            //mapTypeId: 'hybrid'
        });
        var icon = {
            url: "https://firebasestorage.googleapis.com/v0/b/api-project-796350111526.appspot.com/o/gps.svg?alt=media&token=def31471-155c-4d9a-9a46-d428459517c0",
            anchor: new google.maps.Point(25, 50),
            scaledSize: new google.maps.Size(50, 50),
            animated: true
        }

        var marker = new google.maps.Marker({
            position: pt,
            map: map,
            icon: icon,
            anchorPoint: new google.maps.Point(0, -29),
            optimized: false
        });

        //center = bounds.getCenter();
        //map.fitBounds(bounds);

        var contentString = '<div id="content">' +
                '<h6><b>&nbsp;CarId:-</b></h6>' +
                '<h3 id="firstHeading" class="firstHeading">&nbsp;&nbsp;&nbsp;<?= empty($data->car_id) ? '' : $data->car_id ?></h3>' +
                '<div id="bodyContent">' +
                '<h5><b>&nbsp;&nbsp;&nbsp;&nbsp;<?= empty($data->email) ? '' : $data->email ?></b</h5>' +
                '</div>' +
                '</div>';


        var infowindow = new google.maps.InfoWindow({
            content: contentString
        });
        marker.addListener('click', function () {
            infowindow.open(map, marker);
        });

        // Initialize Firebase
        var config = {
            apiKey: "AIzaSyACOf13AS7-u3OxHnaiYAa6fvJ56D7nbLg",
            authDomain: "trackme-230cf.firebaseapp.com",
            databaseURL: "https://trackme-230cf.firebaseio.com",
            projectId: "trackme-230cf",
            storageBucket: "trackme-230cf.appspot.com",
            messagingSenderId: "972128854555"
        };
        firebase.initializeApp(config);

        var database = firebase.database();

        var leadsRef = database.ref('/locations/<?= $data->device_id ?>/');
        leadsRef.on('value', function (snapshot) {
            var childData = snapshot.val();
            position = new google.maps.LatLng(childData.last_lat, childData.last_long);
            marker.setPosition(position);
        });
    }

</script>
<script async defer
        src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDmKN8tuQrP13nGN82YbSInjLi487BHOm4&callback=initMap">

</script>



@include('layout.footer')




