@include('layout.header')

@include('layout.sidebar')
<!-------- Customizable Css for Map  ----------------------------->
<style type="text/css">
    html {
        height: 100%;
    }
    body {
        height: 100%;
        margin: 0;
        padding: 0;
    }
    #map {
        margin: 0;
        padding: 0;
        height: 550px;
        max-width: none;
    }
    #map img {
        max-width: none !important;
    }
    .gm-style-iw {
        top: 15px !important;
        left: 0px !important;
        background-color: #fff;
    }
    #iw-container {
        margin-bottom: 10px;
    }
    #iw-container .iw-title {
        font-family: 'Open Sans Condensed', sans-serif;
        font-size: 22px;
        font-weight: 400;
        padding: 10px;
        background-color: #48b5e9;
        color: white;
        margin: 0;
        border-radius: 2px 2px 0 0;
    }
    #iw-container .iw-content {
        font-size: 13px;
        line-height: 18px;
        font-weight: 400;
        margin-right: 1px;
        padding: 15px 5px 20px 15px;
        max-height: 140px;
        overflow-y: auto;
        overflow-x: hidden;
    }
    .iw-content img {
        float: right;
        margin: 0 5px 5px 10px;	
    }
    .iw-subTitle {
        font-size: 16px;
        font-weight: 700;
        padding: 5px 0;
    }
    .iw-bottom-gradient {
        position: absolute;
        width: 326px;
        height: 25px;
        bottom: 10px;
        right: 18px;
        background: linear-gradient(to bottom, rgba(255,255,255,0) 0%, rgba(255,255,255,1) 100%);
        background: -webkit-linear-gradient(top, rgba(255,255,255,0) 0%, rgba(255,255,255,1) 100%);
        background: -moz-linear-gradient(top, rgba(255,255,255,0) 0%, rgba(255,255,255,1) 100%);
        background: -ms-linear-gradient(top, rgba(255,255,255,0) 0%, rgba(255,255,255,1) 100%);
    }
</style>

<script src="https://www.gstatic.com/firebasejs/4.3.0/firebase.js"></script>
<script type="text/javascript" src="//ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>

<div class="vd_content-wrapper">
    <div class="vd_container">
        <div class="vd_content clearfix">
            <div class="vd_content-section clearfix">
                <div id="map"></div>
            </div>
        </div>
    </div>
</div>
<script>
    function initMap() {

        // var bounds = new google.maps.LatLngBounds();
        var pt = new google.maps.LatLng(-14.470020, -57.557605);
        //bounds.extend(pt);

        var map = new google.maps.Map(document.getElementById('map'), {
            zoom: 4,
            center: {lat: -14.470020, lng: -57.557605},
            mapTypeId: 'roadmap'
        });

        var config = {
            apiKey: "AIzaSyACOf13AS7-u3OxHnaiYAa6fvJ56D7nbLg",
            authDomain: "trackme-230cf.firebaseapp.com",
            databaseURL: "https://trackme-230cf.firebaseio.com",
            projectId: "trackme-230cf",
            storageBucket: "trackme-230cf.appspot.com",
            messagingSenderId: "972128854555"
        };
        firebase.initializeApp(config);

        var database = firebase.database();

        var leadsRef = database.ref('/locations');
        var is_main = <?php echo Session::get('AdminData')->is_main ?>;
        if (is_main != 1) {
            var email = '<?php echo Session::get('AdminData')->email ?>';

            leadsRef.orderByChild('sub_admin_email').equalTo(email).on('child_added', function (userSnap) {

                var icon = '';
                if (userSnap.val().status == "ONLINE") {
                    icon = {
                        url: "https://firebasestorage.googleapis.com/v0/b/api-project-796350111526.appspot.com/o/online.svg?alt=media&token=cf90d36f-76ae-4013-b9c6-ca9cd4b0f38c",
                        anchor: new google.maps.Point(25, 50),
                        scaledSize: new google.maps.Size(50, 50),
                        animated: true
                    }
                } else if (userSnap.val().status == "OFFLINE") {
                    icon = {
                        url: "https://firebasestorage.googleapis.com/v0/b/api-project-796350111526.appspot.com/o/offline.svg?alt=media&token=e816db0d-97d4-4207-9496-71c0c9a4dfaa",
                        anchor: new google.maps.Point(25, 50),
                        scaledSize: new google.maps.Size(50, 50),
                        animated: true
                    }
                } else if (userSnap.val().status == "TRACKING") {
                    icon = {
                        url: "https://firebasestorage.googleapis.com/v0/b/api-project-796350111526.appspot.com/o/gps.svg?alt=media&token=def31471-155c-4d9a-9a46-d428459517c0",
                        anchor: new google.maps.Point(25, 50),
                        scaledSize: new google.maps.Size(50, 50),
                        animated: true
                    }
                } else {
                    icon = {
                        url: "https://firebasestorage.googleapis.com/v0/b/api-project-796350111526.appspot.com/o/offline.svg?alt=media&token=e816db0d-97d4-4207-9496-71c0c9a4dfaa",
                        anchor: new google.maps.Point(25, 50),
                        scaledSize: new google.maps.Size(50, 50),
                        animated: true
                    }
                }
                var marker = new google.maps.Marker({
                    position: new google.maps.LatLng(userSnap.val().last_lat, userSnap.val().last_long),
                    draggable: false,
                    optimized: false,
                    raiseOnDrag: true,
                    map: map,
                    icon: icon
                });
                var infowindow = '';
                var contentString = '';
                leadsRef.child(userSnap.key).on('value', function (snapshot) {
                    var childData = snapshot.val();
                    var icon = '';
                    //console.log(childData);
                    if (childData.status == "ONLINE") {
                        icon = {
                            url: "https://firebasestorage.googleapis.com/v0/b/api-project-796350111526.appspot.com/o/online.svg?alt=media&token=cf90d36f-76ae-4013-b9c6-ca9cd4b0f38c",
                            anchor: new google.maps.Point(25, 50),
                            scaledSize: new google.maps.Size(50, 50),
                            animated: true
                        }
                    } else if (childData.status == "OFFLINE") {
                        icon = {
                            url: "https://firebasestorage.googleapis.com/v0/b/api-project-796350111526.appspot.com/o/offline.svg?alt=media&token=e816db0d-97d4-4207-9496-71c0c9a4dfaa",
                            anchor: new google.maps.Point(25, 50),
                            scaledSize: new google.maps.Size(50, 50),
                            animated: true
                        }
                    } else if (childData.status == "TRACKING") {
                        icon = {
                            url: "https://firebasestorage.googleapis.com/v0/b/api-project-796350111526.appspot.com/o/gps.svg?alt=media&token=def31471-155c-4d9a-9a46-d428459517c0",
                            anchor: new google.maps.Point(25, 50),
                            scaledSize: new google.maps.Size(50, 50),
                            animated: true
                        }
                    } else {
                        icon = {
                            url: "https://firebasestorage.googleapis.com/v0/b/api-project-796350111526.appspot.com/o/offline.svg?alt=media&token=e816db0d-97d4-4207-9496-71c0c9a4dfaa",
                            anchor: new google.maps.Point(25, 50),
                            scaledSize: new google.maps.Size(50, 50),
                            animated: true
                        }
                    }
                    if (childData.last_lat != '' && childData.last_long != '') {
                        position = new google.maps.LatLng(childData.last_lat, childData.last_long);
                        marker.setPosition(position);
                        marker.setIcon(icon);
                        if (childData.sub_admin_email == null) {
                            childData.sub_admin_email = 'No sub admin';
                        }
                        if (childData.car_id == null) {
                            childData.car_id = 'CarId empty';
                        }
                        contentString = '<div id="content">' +
                                '<h3 id="firstHeading" class="firstHeading">&nbsp;&nbsp;&nbsp;' + childData.car_id + '</h3>' +
                                '<div id="bodyContent">' +
                                '<h5><b>&nbsp;&nbsp;&nbsp;&nbsp;' + childData.sub_admin_email + '</b</h5>' +
                                '</div>' +
                                '</div>';
                        infowindow = new google.maps.InfoWindow({
                            content: contentString
                        });
                    }
                })
                marker.addListener('click', function () {
                    infowindow.open(map, marker);
                })
            })
        } else {
            leadsRef.on('child_added', function (userSnap) {

                var icon = '';
                if (userSnap.val().status == "ONLINE") {
                    icon = {
                        url: "https://firebasestorage.googleapis.com/v0/b/api-project-796350111526.appspot.com/o/online.svg?alt=media&token=cf90d36f-76ae-4013-b9c6-ca9cd4b0f38c",
                        anchor: new google.maps.Point(25, 50),
                        scaledSize: new google.maps.Size(50, 50),
                        animated: true
                    }
                } else if (userSnap.val().status == "OFFLINE") {
                    icon = {
                        url: "https://firebasestorage.googleapis.com/v0/b/api-project-796350111526.appspot.com/o/offline.svg?alt=media&token=e816db0d-97d4-4207-9496-71c0c9a4dfaa",
                        anchor: new google.maps.Point(25, 50),
                        scaledSize: new google.maps.Size(50, 50),
                        animated: true
                    }
                } else if (userSnap.val().status == "TRACKING") {
                    icon = {
                        url: "https://firebasestorage.googleapis.com/v0/b/api-project-796350111526.appspot.com/o/gps.svg?alt=media&token=def31471-155c-4d9a-9a46-d428459517c0",
                        anchor: new google.maps.Point(25, 50),
                        scaledSize: new google.maps.Size(50, 50),
                        animated: true
                    }
                } else {
                    icon = {
                        url: "https://firebasestorage.googleapis.com/v0/b/api-project-796350111526.appspot.com/o/offline.svg?alt=media&token=e816db0d-97d4-4207-9496-71c0c9a4dfaa",
                        anchor: new google.maps.Point(25, 50),
                        scaledSize: new google.maps.Size(50, 50),
                        animated: true
                    }
                }
                var marker = new google.maps.Marker({
                    position: new google.maps.LatLng(userSnap.val().last_lat, userSnap.val().last_long),
                    draggable: false,
                    optimized: false,
                    raiseOnDrag: true,
                    map: map,
                    icon: icon
                });
                var infowindow = '';
                var contentString = '';
                leadsRef.child(userSnap.key).on('value', function (snapshot) {
                    var childData = snapshot.val();
                    //console.log(childData);
                    if (childData.status == "ONLINE") {
                        icon = {
                            url: "https://firebasestorage.googleapis.com/v0/b/api-project-796350111526.appspot.com/o/online.svg?alt=media&token=cf90d36f-76ae-4013-b9c6-ca9cd4b0f38c",
                            anchor: new google.maps.Point(25, 50),
                            scaledSize: new google.maps.Size(50, 50),
                            animated: true
                        }
                    } else if (childData.status == "OFFLINE") {
                        icon = {
                            url: "https://firebasestorage.googleapis.com/v0/b/api-project-796350111526.appspot.com/o/offline.svg?alt=media&token=e816db0d-97d4-4207-9496-71c0c9a4dfaa",
                            anchor: new google.maps.Point(25, 50),
                            scaledSize: new google.maps.Size(50, 50),
                            animated: true
                        }
                    } else if (childData.status == "TRACKING") {
                        icon = {
                            url: "https://firebasestorage.googleapis.com/v0/b/api-project-796350111526.appspot.com/o/gps.svg?alt=media&token=def31471-155c-4d9a-9a46-d428459517c0",
                            anchor: new google.maps.Point(25, 50),
                            scaledSize: new google.maps.Size(50, 50),
                            animated: true
                        }
                    } else {
                        icon = {
                            url: "https://firebasestorage.googleapis.com/v0/b/api-project-796350111526.appspot.com/o/offline.svg?alt=media&token=e816db0d-97d4-4207-9496-71c0c9a4dfaa",
                            anchor: new google.maps.Point(25, 50),
                            scaledSize: new google.maps.Size(50, 50),
                            animated: true
                        }
                    }
                    if (childData.last_lat != '' && childData.last_long != '') {
                        position = new google.maps.LatLng(childData.last_lat, childData.last_long);
                        marker.setPosition(position);
                        marker.setIcon(icon);
                        if (childData.sub_admin_email == null) {
                            childData.sub_admin_email = 'No sub admin';
                        }
                        if (childData.car_id == null) {
                            childData.car_id = 'CarId empty';
                        }
                        contentString = '<div id="content">' +
                                '<h3 id="firstHeading" class="firstHeading">&nbsp;&nbsp;&nbsp;' + childData.car_id + '</h3>' +
                                '<div id="bodyContent">' +
                                '<h5><b>&nbsp;&nbsp;&nbsp;&nbsp;' + childData.sub_admin_email + '</b</h5>' +
                                '</div>' +
                                '</div>';
                        infowindow = new google.maps.InfoWindow({
                            content: contentString
                        });
                    }
                })
                marker.addListener('click', function () {
                    infowindow.open(map, marker);
                })
            })
        }
    }


</script>
<script async defer
        src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDmKN8tuQrP13nGN82YbSInjLi487BHOm4&callback=initMap">
</script>
@include('layout.footer')




